/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.AdministratorBean;
import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoTasklet;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.List;

public class AdministratorTasklet
extends PanelTasklet
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XSETADTT";
    private static final String TRACE_MASKF = "XSETADTF";
    private static final String TRACE_MASKD = "XSETADTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "AdmInfoTskl");
    private AdministratorBean adminBean;
    private List availCountries;
    private List availSubdivisions;

    public AdministratorTasklet() {
        Trace.trace(TRACE_MASKT, "<> AdministratorTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.adminBean = new AdministratorBean();
                this.adminBean.setBeanName("AdministratorBean");
                CustomerInfoTasklet custInfoTasklet = (CustomerInfoTasklet)this.getParent();
                CustomerInfoData custInfoData = custInfoTasklet.getCustInfoData();
                this.adminBean.setCompanyName(custInfoData.getAdminCompany());
                this.adminBean.setAdministratorName(custInfoData.getAdminName());
                this.adminBean.setEmailAddress(custInfoData.getAdminEmail());
                this.adminBean.setPhoneNumber(custInfoData.getAdminPhone());
                this.adminBean.setAlternatePhoneNumber(custInfoData.getAdminAltPhone());
                this.adminBean.setFaxNumber(custInfoData.getAdminFax());
                this.adminBean.setAlternateFaxNumber(custInfoData.getAdminAltFax());
                this.adminBean.setStreetAddress(custInfoData.getAdminStreetAddr());
                this.adminBean.setStreetAddress2(custInfoData.getAdminStreetAddr2());
                this.adminBean.setCityLocality(custInfoData.getAdminCity());
                this.adminBean.setAvailCountries(custInfoTasklet.getAvailCountries());
                this.adminBean.setCountryCode(custInfoData.getAdminCountryCode());
                this.adminBean.setAvailSubdivisions(custInfoTasklet.getAvailSubdivisions());
                this.adminBean.setSubdivisionCode(custInfoData.getAdminSubdivisionCode());
                this.adminBean.setPostalCode(custInfoData.getAdminPostalCode());
                response.replace("com.ibm.hwmca.base.custinfo.res.CustomerInfoRes", "AdministratorPanel", this.adminBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("AdministratorPanel")) {
                    this.serviceAdministratorPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 2068, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceAdministratorPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceAdministratorPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            AdministratorBean bean = (AdministratorBean)request.getData("Bean");
            if (bean != null) {
                CustomerInfoTasklet custInfoTasklet = (CustomerInfoTasklet)this.getParent();
                CustomerInfoData custInfoData = custInfoTasklet.getCustInfoData();
                custInfoData.setAdminCompany(bean.getCompanyName());
                custInfoData.setAdminName(bean.getAdministratorName());
                custInfoData.setAdminEmail(bean.getEmailAddress());
                custInfoData.setAdminPhone(bean.getPhoneNumber());
                custInfoData.setAdminAltPhone(bean.getAlternatePhoneNumber());
                custInfoData.setAdminFax(bean.getFaxNumber());
                custInfoData.setAdminAltFax(bean.getAlternateFaxNumber());
                custInfoData.setAdminStreetAddr(bean.getStreetAddress());
                custInfoData.setAdminStreetAddr2(bean.getStreetAddress2());
                custInfoData.setAdminCity(bean.getCityLocality());
                custInfoData.setAdminCountryCode(bean.getCountryCode());
                custInfoData.setAdminSubdivisionCode(bean.getSubdivisionCode());
                custInfoData.setAdminPostalCode(bean.getPostalCode());
                Trace.trace(TRACE_MASKF, custInfoData.toString());
            }
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceAdministratorPanel()");
    }
}

